import type { WorkerRequestHandler, WorkerUpgradeHandler } from './types';
import type { NextServer } from '../next';
import '../node-environment';
import '../require-hook';
import { type Span } from '../../trace';
export type RenderServer = Pick<typeof import('./render-server'), 'initialize' | 'clearModuleContext' | 'propagateServerField' | 'getServerField'>;
export interface LazyRenderServerInstance {
    instance?: RenderServer;
}
export declare function initialize(opts: {
    dir: string;
    port: number;
    dev: boolean;
    onCleanup: (listener: () => Promise<void>) => void;
    server?: import('http').Server;
    minimalMode?: boolean;
    hostname?: string;
    keepAliveTimeout?: number;
    customServer?: boolean;
    experimentalHttpsServer?: boolean;
    startServerSpan?: Span;
    quiet?: boolean;
}): Promise<[WorkerRequestHandler, WorkerUpgradeHandler, NextServer]>;
