import React from 'react';
import { type OverlayState } from '../shared';
import { type SupportedErrorEvent } from '../internal/container/Errors';
import type { Dispatcher } from './hot-reloader-client';
interface ReactDevOverlayState {
    reactError: SupportedErrorEvent | null;
}
export default class ReactDevOverlay extends React.PureComponent<{
    state: OverlayState;
    dispatcher?: Dispatcher;
    children: React.ReactNode;
}, ReactDevOverlayState> {
    state: {
        reactError: null;
    };
    static getDerivedStateFromError(error: Error): ReactDevOverlayState;
    render(): import("react/jsx-runtime").JSX.Element;
}
export {};
