import type { Schema, Struct } from '@strapi/strapi';

export interface OrderOrderBeverage extends Struct.ComponentSchema {
  collectionName: 'components_order_order_beverages';
  info: {
    description: '';
    displayName: 'order-beverage';
    icon: 'bell';
  };
  attributes: {
    beverage_name: Schema.Attribute.String;
    main_category: Schema.Attribute.Relation<
      'oneToOne',
      'api::main-category.main-category'
    >;
    name: Schema.Attribute.String;
    sub_categories: Schema.Attribute.Relation<
      'oneToMany',
      'api::sub-category.sub-category'
    >;
  };
}

declare module '@strapi/strapi' {
  export module Public {
    export interface ComponentSchemas {
      'order.order-beverage': OrderOrderBeverage;
    }
  }
}
